//
//  NumberInput.h
//  Composr Mobile SDK
//
//  Created by Aaswini on 26/01/15.
//  Copyright (c) 2015 Aaswini. All rights reserved.
//
import UIKit
class NumberInput: UIView, UITextFieldDelegate {
    var txtInput: UITextField!

    var text = ""
    var defaultValue = ""
    var placeHolder = ""
    var supportFloat = false

    override init(frame: CGRect, defaultValue: String, placeHolder: String, supportFloat: Bool) {
        super.init(frame: frame)
        
        self.defaultValue! = defaultValue
        self.placeHolder = placeHolder
        self.supportFloat = supportFloat
        self.initialize()
    
    }


    override init(frame: CGRect) {
        super.init(frame: frame)
        
        self.initialize()
    
    }

    override func initialize() {
        txtInput = UITextField(frame: CGRectMake(0, 0, self.frame.size.width, self.frame.size.height))
        txtInput.keyboardType = .NumbersAndPunctuation
        txtInput.placeholder = self.placeHolder
        txtInput.tag = 111
        txtInput.delegate = self
        txtInput.borderStyle = .RoundedRect
        txtInput.returnKeyType = UIReturnKeyDone
        txtInput.clearButtonMode = .WhileEditing
        txtInput.contentVerticalAlignment = .Center
        if self.defaultValue! != nil && !(self.defaultValue! == "") {
            txtInput.text = self.defaultValue!
            self.text = txtInput.text
        }
        self.addSubview(txtInput)
    }
// MARK: UITextFieldDelegate

    func textFieldShouldReturn(textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        return true
    }

    func textField(textField: UITextField, shouldChangeCharactersInRange range: NSRange, replacementString string: String) -> Bool {
        if !string.characters.count {
            return true
        }
        if textField == txtInput {
            do {
                if self.supportFloat {
                            var newString = textField.text.stringByReplacingCharactersInRange(range, withString: string)
                            var expression = "^([0-9]+)?(\\.([0-9]{1,2})?)?$"
                            var regex = try NSRegularExpression(pattern: expression, options: NSRegularExpressionCaseInsensitive)
                            var numberOfMatches = regex.numberOfMatchesInString(newString, options: [], range: NSMakeRange(0, newString.characters.count))
                            if numberOfMatches == 0 {
                                return false
                            }
                        }
                        else {
                            var newString = textField.text.stringByReplacingCharactersInRange(range, withString: string)
                            var expression = "^([0-9]+)?(([0-9]{1,2})?)?$"
                            var regex = try NSRegularExpression(pattern: expression, options: NSRegularExpressionCaseInsensitive)
                            var numberOfMatches = regex.numberOfMatchesInString(newString, options: [], range: NSMakeRange(0, newString.characters.count))
                            if numberOfMatches == 0 {
                                return false
                            }
                        }
            }
            catch let error {
            }
        }
        return true
    }
}